import React,{useState,useEffect} from 'react'
import './App.css';

import ReactDOM from "react-dom";
import Geolocation from "./Content";

function App() {


  useEffect(() => {
  
    getCurrentPosition();

  },[]);

 const getCurrentPosition = () => {

    const geolocation = navigator.geolocation;

    geolocation.getCurrentPosition(
      position => {
        console.log(position);
      },
      () => {
        console.log(new Error("Permission denied"));
      }
    );
  };


  return (
    <div className="App">
     
        <Geolocation
          render={({
            fetchingPosition,
            position: { coords: { latitude, longitude } = {} } = {},
            error,
            getCurrentPosition
          }) => (
            <div>
              <button onClick={getCurrentPosition}>Get Position</button>
              <br />
              <br />
              {error && <div>{error.message}</div>}
              <pre>
                latitude: {latitude}
                <br />
                <br />
                longitude: {longitude}
              </pre>
            </div>
          )}
        />
    </div>
  );
}

export default App;
