<?php
require_once ('config.php');
$error_message;
$valid = true;
$now = date("Ymdhisa");
$file_name = __DIR__ . "\mobile_log\_update_asset.log";

/* Begin the transaction. */
if (sqlsrv_begin_transaction($conn) === false)
{
    die(print_r(sqlsrv_errors() , true));
}

$json = file_get_contents('php://input');
// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$asset_no = $data['ast_mst_asset_no'];
$asset_group = $data['ast_mst_asset_grpcode'];
$asset_shortdesc = $data['ast_mst_asset_shortdesc'];
$asset_type = $data['ast_mst_asset_type'];
$asset_code = $data['ast_mst_asset_code'];
$work_area = $data['ast_mst_work_area'];
$asset_locn = $data['ast_mst_asset_locn'];
$asset_lvl = $data['ast_mst_ast_lvl'];
$asset_status = $data['ast_mst_asset_status'];
$cri_factor = $data['ast_mst_cri_factor'];
$cost_center = $data['ast_mst_cost_center'];
$warranty_date = $data['ast_det_warranty_date'];
$EmpID = $data['EmpID'];
$RowID = $data['RowID'];
$work_remake = $data['work_remake'];
$Loc_remake = $data['Loc_remake'];
$LogingID = $data['LOGINID'];

$sql = "SELECT ast_mst_asset_status,ast_mst_work_area,ast_mst_asset_locn From ast_mst WHERE site_cd = '" . $site_cd . "' AND ast_mst_asset_no = '" . $asset_no . "'";

$stmt = sqlsrv_query($conn, $sql);

if ($stmt === false)
{
    if (($errors = sqlsrv_errors()) != null)
    {
        foreach ($errors as $error)
        {
			
            file_put_contents($file_name, $now . "\r\n" . $sql . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);		
        }
    }
    sqlsrv_rollback($conn);
    sqlsrv_close($conn);
	
	$error_message = "(".$now.") Error selecting table (ast_mst)";
	returnError($error_message);	
}
do
{
    while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))
    {

        $ast_mst_asset_status = $row['ast_mst_asset_status'];
        $ast_mst_work_area = $row['ast_mst_work_area'];
        $ast_mst_asset_locn = $row['ast_mst_asset_locn'];

    }
}
while (sqlsrv_next_result($stmt));
sqlsrv_free_stmt($stmt);

if ($ast_mst_asset_status != $asset_status)
{

    $sql = "UPDATE	ast_aud 
		SET			ast_aud_end_date = GetDate(),
					ast_aud_duration = 0,
					audit_user = ? ,
					audit_date = getdate(),
					mbl_audit_user = ?,
					mbl_audit_date = getdate()
					
		WHERE		ast_aud_end_date IS NULL
		AND			site_cd = ?
		AND			ast_aud_asset_no = ?
		AND			ast_aud_status = ?
		AND			mst_RowID = ?";

    $params_update_ast_aud = array($LogingID,$LogingID,$site_cd,$asset_no,$ast_mst_asset_status,$RowID);
	
    $stmt_update_ast_aud = sqlsrv_query($conn, $sql, $params_update_ast_aud);

    if ($stmt_update_ast_aud === false)
    {
        if (($errors = sqlsrv_errors()) != null)
        {
            foreach ($errors as $error)
            {
                file_put_contents($file_name, $now . "\r\n" . $sql . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);			
            }
        }
				
        sqlsrv_rollback($conn);
        sqlsrv_close($conn);
		
		$error_message = "(".$now.") Error updating table (ast_aud)";
		returnError($error_message);		
    }
    sqlsrv_free_stmt($stmt_update_ast_aud);

    $sql_insert_ast_aud = "INSERT INTO ast_aud
						(	site_cd ,					mst_RowID ,				ast_aud_asset_no ,			ast_aud_status ,	ast_aud_originator , 
							ast_aud_start_date ,		ast_aud_end_date ,		ast_aud_duration ,			audit_user ,		audit_date, 
							mbl_audit_user,				mbl_audit_date) 												
				VALUES	(	?,							?,						?,							?,					?,
							GetDate(),					NULL,					NULL,						?,					GetDate(),
							?,							GetDate())";

    $params_insert_ast_aud = array( $site_cd,$RowID,$asset_no,$asset_status,$EmpID,$LogingID,$LogingID);
    $stmt_insert_ast_aud = sqlsrv_query($conn, $sql_insert_ast_aud, $params_insert_ast_aud);

    if ($stmt_insert_ast_aud === false)
    {
        if (($errors = sqlsrv_errors()) != null)
        {
            foreach ($errors as $error)
            {
                file_put_contents($file_name, $now . "\r\n" . $sql_insert_ast_aud . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
            }
        }
        sqlsrv_rollback($conn);
        sqlsrv_close($conn);
		
		$error_message = "(".$now.") Error inserting table (ast_aud)";
		returnError($error_message);
    }
    sqlsrv_free_stmt($stmt_insert_ast_aud);

}
if ($ast_mst_work_area != $work_area)
{

    $sql_insert_ast_aud = "INSERT INTO ast_war_s
						( 	site_cd,				ast_war_s_asset_no,		ast_war_s_asset_olocn,		ast_war_s_asset_nlocn,				ast_war_s_asset_reason, 
							audit_user,				audit_date,				column1,					column2,							column3, 
							column4, 				column5,				mbl_audit_user,				mbl_audit_date )											
				VALUES	(	?,						?,						?,							?,									?,
							?,						GETDATE(),				NULL,						NULL,								NULL,
							NULL,					NULL,					?,							GETDATE())";

    $params_ast_war_s = array( $site_cd,$asset_no,$ast_mst_work_area,$work_area, $work_remake,$LogingID,$LogingID);
    $stmt_ast_war_s = sqlsrv_query($conn, $sql_insert_ast_aud, $params_ast_war_s);

    if ($stmt_ast_war_s === false)
    {
        if (($errors = sqlsrv_errors()) != null)
        {
            foreach ($errors as $error)
            {
                file_put_contents($file_name, $now . "\r\n" . $sql_insert_ast_aud . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
            }
        }	
        sqlsrv_rollback($conn);
        sqlsrv_close($conn);
		
		$error_message = "(".$now.") Error inserting table (ast_war_s)";
		returnError($error_message);
    }
    sqlsrv_free_stmt($stmt_ast_war_s);

}
if ($ast_mst_asset_locn != $asset_locn)
{

    $sql_insert_ast_aud = "INSERT INTO ast_loc_s
						( 	site_cd,				ast_loc_s_asset_no,		ast_loc_s_asset_olocn,		ast_loc_s_asset_nlocn,				ast_loc_s_asset_reason, 
							audit_user,				audit_date,				column1,					column2,							column3, 
							column4, 				column5,				mbl_audit_user,				mbl_audit_date  )											
				VALUES	(	?,						?,						?,							?,									?,
							?,						GETDATE(),				NULL,						NULL,								NULL,
							NULL,					NULL,					?,							GETDATE())";

    $params_ast_loc_s = array(  $site_cd,        $asset_no,        $ast_mst_asset_locn,        $asset_locn,        $Loc_remake,        $LogingID , $LogingID    );
    $stmt_ast_loc_s = sqlsrv_query($conn, $sql_insert_ast_aud, $params_ast_loc_s);

    if ($stmt_ast_loc_s === false)
    {
        if (($errors = sqlsrv_errors()) != null)
        {
            foreach ($errors as $error)
            {
                file_put_contents($file_name, $now . "\r\n" . $sql_insert_ast_aud . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
            }
        }
        sqlsrv_rollback($conn);
        sqlsrv_close($conn);
		
		$error_message = "(".$now.") Error inserting table (ast_loc_s)";
		returnError($error_message);
    }
    sqlsrv_free_stmt($stmt_ast_loc_s);

}

$sql = "UPDATE ast_mst 
		SET ast_mst_asset_shortdesc =?,
			ast_mst_asset_type 	= ?,
			ast_mst_asset_grpcode= ?,
			ast_mst_work_area	= ?,
			ast_mst_asset_locn	= ?,
			ast_mst_ast_lvl		= ?,
			ast_mst_asset_status= ?,
			ast_mst_cri_factor	= ?,
			ast_mst_cost_center	= ?,
			ast_mst.audit_user 	= ?,
			ast_mst.audit_date 	= GETDATE(),
			ast_mst.mbl_audit_user		=?,
			ast_mst.mbl_audit_date		= GETDATE()
		WHERE site_cd =?
		AND ast_mst_asset_no =? 
		AND RowID = ?";

$params_ast_mst = array(
    $asset_shortdesc,
    $asset_type,
    $asset_group,
    $work_area,
    $asset_locn,
    $asset_lvl,
    $asset_status,
    $cri_factor,
    $cost_center,
    $LogingID,
	$LogingID,
    $site_cd,
    $asset_no,
    $RowID
);
$stmt_ast_mst = sqlsrv_query($conn, $sql, $params_ast_mst);

if ($stmt_ast_mst === false)
{
    if (($errors = sqlsrv_errors()) != null)
    {
        foreach ($errors as $error)
        {
            file_put_contents($file_name, $now . "\r\n" . $sql . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
        }
    }
	
	$error_message = "(".$now.") Error updating table (ast_mst)";
	returnError($error_message);
	
    sqlsrv_rollback($conn);
    sqlsrv_close($conn);
}
sqlsrv_free_stmt($stmt_ast_mst);

$sql = "UPDATE ast_det 
		SET ast_det_warranty_date =?,			
			ast_det.audit_user = ?,
			ast_det.audit_date = GETDATE(),
			ast_det.mbl_audit_user = ?,
			ast_det.mbl_audit_date = GETDATE()
			
		WHERE site_cd =? 		
		AND mst_RowID = ?";

$params_ast_det = array(
    $warranty_date,
    $LogingID,
	$LogingID,
    $site_cd,
    $RowID
);
$stmt_ast_det = sqlsrv_query($conn, $sql, $params_ast_det);

if ($stmt_ast_det === false)
{
    if (($errors = sqlsrv_errors()) != null)
    {
        foreach ($errors as $error)
        {
            file_put_contents($file_name, $now . "\r\n" . $sql . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
        }
    }
	$error_message = "(".$now.") Error updating table (ast_det)";
	returnError($error_message);
	
    sqlsrv_rollback($conn);
    sqlsrv_close($conn);
}

sqlsrv_free_stmt($stmt_ast_det);

if ($valid)
{
    //f_insert_cf_audit($data, "Asset Register", $LogingID, $site_cd, $RowID);
    sqlsrv_commit($conn);
    sqlsrv_close($conn);
    returnData($asset_no);
}

function returnData($asset_no)
{
    $returnData = array(
        'status' => 'SUCCESS',
        'message' => 'Asset Number ' .$asset_no . ' update successfully'
    );
    echo json_encode($returnData);
}

function returnError($error_message)
{
    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message
    );
    echo json_encode($returnData);
	exit();
}

?>
