<?php

require '../../vendor/autoload.php';

use Google\Auth\ApplicationDefaultCredentials;
use GuzzleHttp\Client;



// Path to your service-account.json file (downloaded from Firebase Console)
$serviceAccountPath = '..\..\react-native-cmms-firebase-adminsdk-l1avp-dfd52abfc2.json';

// Set the GOOGLE_APPLICATION_CREDENTIALS environment variable to the path of your service account JSON
putenv('GOOGLE_APPLICATION_CREDENTIALS=' . $serviceAccountPath);

// Define the required scope for FCM
$scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

// Create the credentials object to retrieve the OAuth token
$auth = ApplicationDefaultCredentials::getCredentials($scopes);

// Fetch the access token
$accessToken = $auth->fetchAuthToken()['access_token'];

// Firebase Cloud Messaging v1 API URL
$projectId = 'react-native-cmms';
$url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";



// FCM device token
$deviceToken = 'dAOp6KPnAkPFjSy7uqr3H3:APA91bEs-nvY85v-nWibNgmVgrg63Vcvqxn5f9N98LbckieVomr-J3nyy3xh_QqqNb-vnJjLFGWs7OP0obrX0cT10xFNgNiiPN7fYeegkuAvtj5oLGwudgha30RUxUAO6-05q_GaVfWY';
//ANDROID
//$deviceToken = 'dDwbv0pxQ3yLL-nDHK-F1-:APA91bHdV_KdZbfsmvkb17QZMXuRGw3fe-cZl9v7H5N8OH9a0D3hnZX8C2oEeQWqWnd6c5-pVqfB_Zh7yFMDNlAhPZeYRPsLfz1NhuGklq2whwZVSQwg_8KSuyFmcD4BEE0pbMx5Fyfk';

// Prepare the message payload
$data = [
    'message' => [
        'token' => $deviceToken, // The FCM device token
        'notification' => [
            'title' => 'Hello from PHP!',
            'body'  => 'This is a test notification using cURL.',
        ],
        'data' => [
            'extra_key' => 'extra_value',
        ],
		'apns'=>[
			'payload' =>[
			
				'aps'=>[
					'sound' =>'default'
				
				]
			]
		
		]
    ]
];

// Encode the payload as JSON
$payload = json_encode($data);

// Initialize cURL session
$ch = curl_init();

// Set the cURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Set the headers
$headers = [
    'Authorization: Bearer ' . $accessToken,
    'Content-Type: application/json',
];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Set the payload
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

// Execute the cURL request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo 'cURL error: ' . curl_error($ch);
} else {
    // Decode the response (if needed) and print it
    $responseBody = json_decode($response, true);
    print_r($responseBody);
}

// Close the cURL session
curl_close($ch);
?>