<?php
// get these values from your DB.
require_once('config.php');
$error_message;
$valid = true;


/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}


$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$EmpID = $data['EmpID'];
$LOGINID = $data['LOGINID'];

$mtr_mst_rowID = $data['mtr_mst_rowID'];
$header_audit_date = $data['header_audit_date'];
$remark = $data['remark'];



$sql_mtr_mst ="Select audit_date from mtr_mst (NOLOCK)  Where site_cd = ? and  RowID = ?";
			
$params_mtr_mst = array($site_cd,$mtr_mst_rowID);

$stmt_mtr_mst = sqlsrv_query( $conn, $sql_mtr_mst,$params_mtr_mst);

if( !$stmt_mtr_mst ) {
	
	 $error_message = "Error selecting mtr_mst";
	 returnError($error_message);
	 die( print_r( sqlsrv_errors(), true));
	 
}	

do {
	
	while ($row = sqlsrv_fetch_array($stmt_mtr_mst, SQLSRV_FETCH_ASSOC)) {		
	
		$audit_date = $row['audit_date']->format('Y-m-d H:i:s');						
		//echo $audit_date;
	}
	
} while ( sqlsrv_next_result($stmt_mtr_mst) );
  sqlsrv_free_stmt( $stmt_mtr_mst);
  			  
if($header_audit_date <> $audit_date){
	 //echo $header_audit_date;
	 //echo $audit_date;
				 
	sqlsrv_rollback( $conn );
	$error_message = "The MR audit date had been changed. The record already updated by another user. Please cancel and retrieve the record again.";
	returnError($error_message);
				
}else{
	
	  


$sql_mtr_det = "UPDATE mtr_det SET 
				mtr_det_note1 = ?,				
				audit_user=?,
				audit_date=getdate(),
				mbl_audit_user=?,		
				mbl_audit_date=getdate()  
				WHERE site_cd=? 
				and mst_rowid  = ?";


$params_mtr_det = array($remark ,$LOGINID,$LOGINID,$site_cd,$mtr_mst_rowID);
$stmt_update_mtr_det = sqlsrv_query( $conn, $sql_mtr_det,$params_mtr_det);	
		
if( !$stmt_update_mtr_det ) {
	$error_message = "Error update table (mtr_det)";
	returnError($error_message);
	die( print_r( sqlsrv_errors(), true));
}sqlsrv_free_stmt( $stmt_update_mtr_det);



$sql_mtr_app ="SELECT	ll_empl_cnt = Count(mtr_app_empl_id), ls_approver = Min(mtr_app_empl_id)
				FROM	mtr_app (NOLOCK)
				WHERE	site_cd = ?
				AND		mst_rowid = ?
				AND		mtr_app_level= ?";

	$params_mtr_app = array($site_cd,$mtr_mst_rowID,1);

	$stmt_select_mtr_mst = sqlsrv_query( $conn, $sql_mtr_app,$params_mtr_app);	

	if( !$stmt_select_mtr_mst ) {

	 $error_message = "Error selecting mtr_mst";
	 returnError($error_message);
	 die( print_r( sqlsrv_errors(), true));
	 
	}	

	do {

	while ($row = sqlsrv_fetch_array($stmt_select_mtr_mst, SQLSRV_FETCH_ASSOC)) {		

		$ll_empl_cnt = $row['ll_empl_cnt'];		
		$ls_approver = $row['ls_approver'];

				//echo $ll_empl_cnt ;		
				//echo $ls_approver ;											

	}

	} while ( sqlsrv_next_result($stmt_select_mtr_mst) );
	sqlsrv_free_stmt( $stmt_select_mtr_mst);  
					
	if($ll_empl_cnt == 1){
		
		$sql_mtr_mst = "UPDATE mtr_mst  SET 
						mtr_mst_status = 'W',	
						mtr_mst_cur_app_level = 0 ,	
						mtr_mst_approver = ?,
						mtr_mst_release_for_app = '0',						
						audit_user= ?,
						audit_date=getdate(),
						mbl_audit_user= ?,		
						mbl_audit_date=getdate()  
						WHERE site_cd= ? 
						and RowID = ?";


			$params_mtr_mst = array($ls_approver,$LOGINID,$LOGINID,$site_cd,$mtr_mst_rowID);
			$stmt_update_mtr_mst = sqlsrv_query( $conn, $sql_mtr_mst,$params_mtr_mst);	
					
			if( !$stmt_update_mtr_mst ) {
				$error_message = "Error update table (mtr_mst)";
				returnError($error_message);
				die( print_r( sqlsrv_errors(), true));
			}sqlsrv_free_stmt( $stmt_update_mtr_mst);
		
	}else if($ll_empl_cnt > 1){
		
		$sql_mtr_mst = "UPDATE mtr_mst  SET 
						mtr_mst_status = 'W',	
						mtr_mst_cur_app_level = 0 ,	
						mtr_mst_approver = ?',
						mtr_mst_release_for_app = '0',						
						audit_user= ?,
						audit_date=getdate(),
						mbl_audit_user= ?,		
						mbl_audit_date=getdate() 
						WHERE site_cd= ? 
						and RowID = ?";


			$params_mtr_mst = array($ls_approver.'...',$LOGINID,$LOGINID,$site_cd,$mtr_mst_rowID);
			$stmt_update_mtr_mst = sqlsrv_query( $conn, $sql_mtr_mst,$params_mtr_mst);	
					
			if( !$stmt_update_mtr_mst ) {
				$error_message = "Error update table (mtr_mst)";
				returnError($error_message);
				die( print_r( sqlsrv_errors(), true));
			}sqlsrv_free_stmt( $stmt_update_mtr_mst);
		
		
	}else if($ll_empl_cnt == 0){
		
		
		$sql_mtr_mst = "UPDATE mtr_mst  SET 
						mtr_mst_status = 'W',	
						mtr_mst_cur_app_level = 0,	
						mtr_mst_approver = NULL,
						mtr_mst_release_for_app = '0',						
						audit_user= ?,
						audit_date= getdate(),
						mbl_audit_user= ?,		
						mbl_audit_date= getdate() 
						WHERE site_cd= ? 
						and RowID = ?";


			$params_mtr_mst = array($LOGINID,$LOGINID,$site_cd,$mtr_mst_rowID);
			$stmt_update_mtr_mst = sqlsrv_query( $conn, $sql_mtr_mst,$params_mtr_mst);	
					
			if( !$stmt_update_mtr_mst ) {
				$error_message = "Error update table (mtr_mst)";
				returnError($error_message);
				die( print_r( sqlsrv_errors(), true));
			}sqlsrv_free_stmt( $stmt_update_mtr_mst);
		
		
	}			


$sql_mtr_app = "UPDATE mtr_app  SET 
				mtr_app_status = 'P',	
				mtr_app_desc = NULL,
				mtr_app_date = NULL,					
				audit_user= ?,
				audit_date=getdate() ,
				mbl_audit_user= ?,		
				mbl_audit_date=getdate()
				WHERE site_cd= ? 
				and RowID = ?";


	$params_mtr_app = array($LOGINID,$LOGINID,$site_cd,$mtr_mst_rowID);
	$stmt_update_mtr_app = sqlsrv_query( $conn, $sql_mtr_app,$params_mtr_app);	
			
	if( !$stmt_update_mtr_app ) {
		$error_message = "Error update table (mtr_app)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}sqlsrv_free_stmt( $stmt_update_mtr_app);
	
	
	


if($stmt_update_mtr_det){
	
	if($stmt_select_mtr_mst){
		
		if($ll_empl_cnt == 1){
			if($stmt_update_mtr_mst){
					sqlsrv_commit( $conn );
					sqlsrv_close( $conn);	
					returnData();
			}else{
					sqlsrv_rollback( $conn );
					$error_message = "Transaction rolled back.<br />";
					returnError($error_message); 
			}
			
		}else if($ll_empl_cnt > 1){
			if($stmt_update_mtr_mst){
					sqlsrv_commit( $conn );
					sqlsrv_close( $conn);	
					returnData();
			}else{
					sqlsrv_rollback( $conn );
					$error_message = "Transaction rolled back.<br />";
					returnError($error_message); 
			}
			
		}else if($ll_empl_cnt == 0){
			if($stmt_update_mtr_mst){
					sqlsrv_commit( $conn );
					sqlsrv_close( $conn);	
					returnData();
			}else{
					sqlsrv_rollback( $conn );
					$error_message = "Transaction rolled back.<br />";
					returnError($error_message); 
			}
			
		}
		
		
	}else{
		sqlsrv_rollback( $conn );
		$error_message = "Transaction rolled back.<br />";
		returnError($error_message); 
	}	

	
	
}else{
	sqlsrv_rollback( $conn );
	$error_message = "Transaction rolled back.<br />";
	returnError($error_message); 
}	


}


function returnData(){
	$returnData = array(
		'status' => 'SUCCESS',
		'message' => 'The Material Request Had Successfully Rejected.');
	echo json_encode($returnData);
}

function returnError($error_message){
	$json = array();
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);
	
	echo json_encode($returnData);
		
}


 
?>