<?php
// Include the database configuration file
require_once('config.php');


// Retrieve employee ID from request
$empl_id = isset($_REQUEST['empl_id']) ? $_REQUEST['empl_id'] : '';

try {
    // Check if employee ID is provided
    if (empty($empl_id)) {
        throw new Exception("Employee ID is required.");
    }

    // SQL query to retrieve default site information
    $sql = "SELECT default_site = default_site + ' : ' + site_name
            FROM cf_user (NOLOCK), cf_site (NOLOCK)
            WHERE cf_user.default_site = cf_site.site_cd
            AND cf_user.empl_id = ?";

    // Parameters for the SQL query
    $params = array($empl_id);

    // Execute the query
    $stmt = sqlsrv_query($conn, $sql, $params, array("Scrollable" => 'keyset'));

    // Check for errors in the query execution
    if (!$stmt) {
        throw new Exception("Error executing SQL query: " . print_r(sqlsrv_errors(), true));
    }

    // Check if there are rows returned
    $has_rows = sqlsrv_has_rows($stmt);

    // Initialize variable for default site
    $default_site = '';

    // Fetch data from the result set if rows exist
    if ($has_rows) {
        while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
            $default_site = $row['default_site'];
        }
    }

    // Free the statement and close the connection
    sqlsrv_free_stmt($stmt);
    sqlsrv_close($conn);

    // Return the fetched data
    returnData($default_site);

} catch (Exception $e) {
    // Handle any exceptions
    $error_message = $e->getMessage();
    returnError($error_message);
}

function returnData($default_site) {
    $returnData = array(
        'status' => 'SUCCESS',
        'message' => 'Successfully fetched default site',
        'default_site' => $default_site
    );

    echo json_encode($returnData);
}

function returnError($error_message) {
    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message,
        'data' => ''
    );

    echo json_encode($returnData);
    exit();
}
?>
