<?php
// get these values from your DB.
require_once('config.php');
$error_message;
$valid = true;


$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$XML = $data['XML'];	



//XML validation
$sql= "select column_name,default_label,cf_label_required from cf_label where language_cd ='DEFAULT' and table_name = 'ast_mst' and column_name in ".$XML." ";
		
		
$stmt_validation = sqlsrv_query( $conn, $sql);

if( !$stmt_validation ) {
     $error_message = "Error selecting table (wrk_ccd)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$XML_validation = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_validation, SQLSRV_FETCH_ASSOC)) {		
		$XML_validation[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_validation) );




//AssetGroupCode
$sql= "SELECT 	ast_grp.ast_grp_grp_cd, ast_grp.ast_grp_desc ,ast_grp_option
		FROM 	ast_grp  (NOLOCK)
		WHERE (	ast_grp.ast_grp_disable_flag =0  ) 
		AND ast_grp.site_cd = '".$site_cd."'ORDER BY ast_grp_grp_cd";


$stmt_ast_grp = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_grp ) {
     $error_message = "Error selecting table (Asset Group Code)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$json_AssetGroupCode = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_grp, SQLSRV_FETCH_ASSOC)) {		
		$json_AssetGroupCode[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_ast_grp) );




//AssetType
$sql= "SELECT ast_type.ast_type_cd, ast_type.ast_type_descs 
		FROM ast_type (NOLOCK)
		WHERE (ast_type.ast_type_disable_flag = 0  ) 
		AND ast_type.site_cd = '".$site_cd."'ORDER BY ast_type_cd";


$stmt_ast_type = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_type ) {
     $error_message = "Error selecting table (Asset Type)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$json_AssetType = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_type, SQLSRV_FETCH_ASSOC)) {		
		$json_AssetType[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_ast_type) );


//AssetCode
$sql= "SELECT ast_cod.ast_cod_ast_cd, ast_cod.ast_cod_desc        
		FROM ast_cod  (NOLOCK)      
		WHERE (ast_cod.ast_cod_disable_flag = 0  ) 
		AND ast_cod.site_cd = '".$site_cd."'ORDER BY ast_cod_ast_cd";


$stmt_ast_cod = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_cod ) {
     $error_message = "Error selecting table (Asset Code)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$json_Assetcode = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_cod, SQLSRV_FETCH_ASSOC)) {		
		$json_Assetcode[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_ast_cod) );



//AssetStatus
$sql= "SELECT ast_sts_status,ast_sts_desc		
		FROM 	ast_sts (NOLOCK)
		WHERE	ast_sts.site_cd = '".$site_cd."'
		AND		ast_sts.ast_sts_typ_cd IN ( 'IN-SERVICE', 'OUT-OF-SERVICE') ORDER BY ast_sts_status";


$stmt_ast_sts = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_sts ) {
     $error_message = "Error selecting table (Asset Status)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$json_AssetStatus = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_sts, SQLSRV_FETCH_ASSOC)) {		
		$json_AssetStatus[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_ast_sts) );




//CriticalFactor
$sql= "SELECT 	ast_cri.ast_cri_cri_factor,ast_cri.ast_cri_desc    
		FROM 	ast_cri  (NOLOCK)
		WHERE (	ast_cri.ast_cri_disable_flag = 0  ) 
		AND ast_cri.site_cd = '".$site_cd."'ORDER BY ast_cri_cri_factor";


$stmt_ast_cri = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_cri ) {
     $error_message = "Error selecting table (Critical Factor)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));	 
}

$json_CriticalFactor = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_cri, SQLSRV_FETCH_ASSOC)) {		
		$json_CriticalFactor[] = $row;	
     }
} while ( sqlsrv_next_result($stmt_ast_cri) );


//CostCenter
$sql= "SELECT 	cf_cost_center.costcenter,cf_cost_center.descs   
		 FROM 	cf_cost_center (NOLOCK)  
		 WHERE (	cf_cost_center.disable_flag = 0  ) 
		 AND cf_cost_center.site_cd = '".$site_cd."' 
		 AND disable_flag = '0'ORDER BY costcenter";


$stmt_cf_cost_center = sqlsrv_query( $conn, $sql);

if( !$stmt_cf_cost_center ) {
     $error_message = "Error selecting table (Cost Center)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));	 
}

$json_CostCenter = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_cf_cost_center, SQLSRV_FETCH_ASSOC)) {		
		$json_CostCenter[] = $row;	
     }
} while ( sqlsrv_next_result($stmt_cf_cost_center) );



//WorkArea
$sql= "SELECT mst_war.mst_war_work_area,mst_war.mst_war_desc 
		FROM mst_war (NOLOCK)
		WHERE (mst_war.mst_war_disable_flag = 0     ) 
		AND mst_war.site_cd = '".$site_cd."'ORDER BY mst_war_work_area ";


$stmt_mst_war = sqlsrv_query( $conn, $sql);

if( !$stmt_mst_war ) {
     $error_message = "Error selecting table (Work Area)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));	 
}

$json_WorkArea = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_mst_war, SQLSRV_FETCH_ASSOC)) {		
		$json_WorkArea[] = $row;	
     }
} while ( sqlsrv_next_result($stmt_mst_war) );




//AssetLocation
$sql= "SELECT 	ast_loc.ast_loc_ast_loc,ast_loc.ast_loc_desc,ast_loc.ast_loc_wr_option,ast_loc.ast_loc_wo_option, ast_loc.ast_loc_pm_option  
		FROM 	ast_loc     (NOLOCK)
		WHERE (	ast_loc.ast_loc_disable_flag = 0      ) 
		AND ast_loc.site_cd = '".$site_cd."'ORDER BY ast_loc_ast_loc";


$stmt_ast_loc = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_loc ) {
     $error_message = "Error selecting table (Asset Location)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));	 
}

$json_AssetLocation = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_loc, SQLSRV_FETCH_ASSOC)) {		
		$json_AssetLocation[] = $row;	
     }
} while ( sqlsrv_next_result($stmt_ast_loc) );


//Level
$sql= "SELECT 	ast_lvl.ast_lvl_ast_lvl, ast_lvl.ast_lvl_desc    
		FROM 	ast_lvl    (NOLOCK)
		WHERE (	ast_lvl.ast_lvl_disable_flag = 0)
		AND ast_lvl.site_cd = '".$site_cd."'ORDER BY ast_lvl_ast_lvl";


$stmt_ast_lvl = sqlsrv_query( $conn, $sql);

if( !$stmt_ast_lvl ) {
     $error_message = "Error selecting table (Level)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));	 
}

$json_Level = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_ast_lvl, SQLSRV_FETCH_ASSOC)) {		
		$json_Level[] = $row;	
     }
} while ( sqlsrv_next_result($stmt_ast_lvl) );


//Block
$sql_Block= "SELECT 		blk_mst.blk_mst_blk_cod, blk_mst.blk_mst_description    
		FROM 		blk_mst (NOLOCK)
		WHERE 		(blk_mst.blk_mst_disable_flag = 0  ) 
		AND			(blk_mst_blk_cod <> '-')
		AND blk_mst.site_cd = '".$site_cd."'";
$stmt_Block = sqlsrv_query( $conn, $sql_Block);

if( !$stmt_Block ) {
     $error_message = "Error selecting table (Block Code)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$Block = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_Block, SQLSRV_FETCH_ASSOC)) {		
		$Block[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_Block) );



//Floor
$sql_Floor= "SELECT 	ast_lvl.ast_lvl_ast_lvl,  ast_lvl.ast_lvl_desc    
		FROM 		ast_lvl (NOLOCK) 
		WHERE (	ast_lvl.ast_lvl_disable_flag = 0) 
		AND	   (ast_lvl_ast_lvl <> '-')
		AND ast_lvl.site_cd = '".$site_cd."'";
$stmt_Floor = sqlsrv_query( $conn, $sql_Floor);

if( !$stmt_Floor ) {
     $error_message = "Error selecting table (Floor Code)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
	 
}

$Floor = array();

do {
     while ($row = sqlsrv_fetch_array($stmt_Floor, SQLSRV_FETCH_ASSOC)) {		
		$Floor[] = $row;	
	
     }
} while ( sqlsrv_next_result($stmt_Floor) );




if( $stmt_validation && $stmt_ast_grp && $stmt_ast_type && $stmt_ast_cod && $stmt_ast_sts && $stmt_ast_cri && $stmt_cf_cost_center && $stmt_mst_war && $stmt_ast_loc && $stmt_ast_lvl && $sql_Block && $sql_Floor) {
		 sqlsrv_commit( $conn );
		 sqlsrv_close( $conn);	
		 returnData($XML_validation,$json_AssetType,$json_Assetcode,$json_AssetStatus,$json_CriticalFactor,$json_CostCenter,
					$json_WorkArea,$json_AssetLocation,$json_Level,$json_AssetGroupCode,$Block,$Floor);	
	} else {
		 sqlsrv_rollback( $conn );
		 $error_message = "Transaction rolled back.<br />";
		 returnError($error_message);
	} 
	

function returnData($XML_validation,$json_AssetType,$json_Assetcode,$json_AssetStatus,$json_CriticalFactor,$json_CostCenter,
			$json_WorkArea,$json_AssetLocation,$json_Level,$json_AssetGroupCode,$Block,$Floor){
	//echo $json;
	$returnData = array(												
	'status' => 'SUCCESS',
	'message' => 'Successfully',
	'XML_validation'=>$XML_validation,
	'AssetGroupCode'=>$json_AssetGroupCode,
	'AssetType' => $json_AssetType,
	'Assetcode' => $json_Assetcode,
	'AssetStatus' => $json_AssetStatus,
	'CriticalFactor' => $json_CriticalFactor,
	'CostCenter' => $json_CostCenter,
	'WorkArea' => $json_WorkArea,
	'AssetLocation' => $json_AssetLocation,
	'Level' => $json_Level,
	'Block' =>$Block,
	'Floor' =>$Floor);
	
	echo json_encode($returnData);
}

function returnError($error_message){
	$json = array();
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message,
	'data' => $json);
	
	echo json_encode($returnData);
	exit();
		
}
	

 
?>