<?php
require_once('config.php');
$error_message;
$valid = true;

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$rowid = $data['rowid'];
$ast_dwntime_asset_no = $data['ast_dwntime_asset_no'];
$ast_dwntime_out_date = $data['ast_dwntime_out_date'];
$ast_dwntime_rts_date = $data['ast_dwntime_rts_date'];
$ast_dwntime_downtime = $data['ast_dwntime_downtime'];
$ast_dwntime_repair_from = $data['ast_dwntime_repair_from'];
$ast_dwntime_repair_to = $data['ast_dwntime_repair_to'];
$ast_dwntime_repairtime = $data['ast_dwntime_repairtime'];
$ast_dwntime_down_wo = $data['ast_dwntime_down_wo'];
$ast_dwntime_up_wo = $data['ast_dwntime_up_wo'];
$ast_dwntime_status_original = $data['ast_dwntime_status_original'];
$ast_dwntime_status_down = $data['ast_dwntime_status_down'];
$ast_dwntime_status_up = $data['ast_dwntime_status_up'];
$ast_dwntime_sched_flag = $data['ast_dwntime_sched_flag'];
//$ast_dwntime_remark = $data['ast_dwntime_remark'];
if ($ast_dwntime_remark = $data['ast_dwntime_remark'] === ''){
	$ast_dwntime_remark =Null;
}else{
	$ast_dwntime_remark = $data['ast_dwntime_remark'];
}

$LogingID = $data['LOGINID'];
$EmpID = $data['EmpID'];
$column1 = $data['column1'];

//Start 
if (sqlsrv_begin_transaction($conn) === false){
	die(print_r(sqlsrv_errors() , true));
}

//Get status Up backend status UP (BEFORE update)
$sql_get_dwntime_status_up = "Select 	ast_dwntime_status_up
					From		ast_dwntime
					Where	ast_dwntime.rowid = ?";	

$params_get_dwntime_status_up = array($rowid);
		
$stmt_get_dwntime_status_up = sqlsrv_query( $conn, $sql_get_dwntime_status_up, $params_get_dwntime_status_up);	
if( !$stmt_get_dwntime_status_up ) {
	$error_message = "Error select table rowid (ast_aud)";
	returnError($error_message);
	die( print_r( sqlsrv_errors(), true));
}

do {
	while ($row = sqlsrv_fetch_array($stmt_get_dwntime_status_up, SQLSRV_FETCH_ASSOC)) {	 
	$ast_dwntime_status_up_before = $row['ast_dwntime_status_up'];		 
	}
} while ( sqlsrv_next_result($stmt_get_dwntime_status_up));

sqlsrv_free_stmt( $stmt_get_dwntime_status_up);

//Update
If (!empty($ast_dwntime_status_down) && !empty($ast_dwntime_status_up) && !empty($ast_dwntime_status_up_before)){
	
	
	//update ast_dwntime
	$current_datetime = date("Y-m-d h:i:s");
	
	$sql_update_ast_dwntime = "Update ast_dwntime 
	
							Set ast_dwntime_status_up =?,
								ast_dwntime_rts_date = ?,
								ast_dwntime_downtime = ?,		
								ast_dwntime_repair_from = ?,
								ast_dwntime_repair_to = ?,
								ast_dwntime_repairtime = ?,
								ast_dwntime_remark=?,
								ast_dwntime_sched_flag=?,
								column1=?,
								audit_user = ?,
								audit_date = Getdate(),
								mbl_audit_user = ?, 
								mbl_audit_date = GetDate ()
						Where	rowid = ?";

	$params_update_ast_dwntime = array($ast_dwntime_status_up,$ast_dwntime_rts_date,	$ast_dwntime_downtime,	$ast_dwntime_repair_from, 	$ast_dwntime_repair_to, 	$ast_dwntime_repairtime, $ast_dwntime_remark,$ast_dwntime_sched_flag,$column1,	$LogingID,$LogingID, $rowid);								
			
	$stmt_update_ast_dwntime = sqlsrv_query( $conn, $sql_update_ast_dwntime, $params_update_ast_dwntime);			
	
	if( !$stmt_update_ast_dwntime ) {
		$error_message = "Error update table (ast_dwntime)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}
	sqlsrv_free_stmt( $stmt_update_ast_dwntime);
	
}else{
	if (!empty($ast_dwntime_status_down) && !empty($ast_dwntime_status_up) && empty($ast_dwntime_status_up_before)){
	
		//update asset master asset status
		$sql_update_asset = "Update 	ast_mst
							Set 		ast_mst_asset_status = ?
							Where	ast_mst_asset_no = ?
							And		ast_mst.site_cd = ?;";		

		$params_update_asset = array($ast_dwntime_status_up, $ast_dwntime_asset_no,	$site_cd);								
				
		$stmt_update_asset = sqlsrv_query( $conn, $sql_update_asset, $params_update_asset);			
		
		if( !$stmt_update_asset ) {
			$error_message = "Error update table (ast_mst)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}
		sqlsrv_free_stmt( $stmt_update_asset);
		
		
		//get ast_aud_rowid
		$sql_get_aud_rowid = "Select 	rowid
							From		ast_aud
							Where	ast_aud_asset_no = ?
							And		site_cd = ?
							And		ast_aud_end_date IS NULL
							And		ast_aud_start_date IS NOT NULL";	

		$params_get_aud_rowid = array($ast_dwntime_asset_no,	$site_cd);
				
		$stmt_get_aud_rowid = sqlsrv_query( $conn, $sql_get_aud_rowid, $params_get_aud_rowid);	
		if( !$stmt_get_aud_rowid ) {
			$error_message = "Error select table rowid (ast_aud)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}
		
		do {
			while ($row = sqlsrv_fetch_array($stmt_get_aud_rowid, SQLSRV_FETCH_ASSOC)) {	 
			$aud_rowid = $row['rowid'];		 
			}
		} while ( sqlsrv_next_result($stmt_get_aud_rowid));
		
		sqlsrv_free_stmt( $stmt_get_aud_rowid);
		
		//update ast_aud
		$current_datetime = date("Y-m-d h:i:s");
		
		$sql_update_ast_aud = "Update 	ast_aud 
							Set		ast_aud_end_date = ?,
									audit_date = getdate(),
									audit_user = ?,
									mbl_audit_user = ?, 
									mbl_audit_date = GetDate ()
							Where	rowid = ?";		

		$params_update_ast_aud = array($current_datetime,	$LogingID,$LogingID,	$aud_rowid);								
				
		$stmt_update_ast_aud = sqlsrv_query( $conn, $sql_update_ast_aud, $params_update_ast_aud);			
		
		if( !$stmt_update_ast_aud ) {
			$error_message = "Error update table ast_aud_end_date(ast_aud)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}
		sqlsrv_free_stmt( $stmt_update_ast_aud);
		
			//get ast_mst_rowid
		$sql_get_ast_mst_rowid = "Select 	ast_mst.rowid from		ast_mst (NOLOCK) Where	ast_mst.ast_mst_asset_no = ? And		ast_mst.site_cd = ?";	
			
		$params_get_ast_mst_rowid = array($ast_dwntime_asset_no,$site_cd);
				
		$stmt_get_ast_mst_rowid = sqlsrv_query( $conn, $sql_get_ast_mst_rowid, $params_get_ast_mst_rowid);	
		if( !$stmt_get_ast_mst_rowid ) {
			$error_message = "Error select table rowid (ast_mst)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}
		
		do {
			while ($row = sqlsrv_fetch_array($stmt_get_ast_mst_rowid, SQLSRV_FETCH_ASSOC)) {	 
			$ast_mst_rowid = $row['rowid'];		 
			}
		} while ( sqlsrv_next_result($stmt_get_ast_mst_rowid));
		
		sqlsrv_free_stmt( $stmt_get_ast_mst_rowid);
		
		//Insert ast_aud
		$sql_insert_ast_aud = "	Insert into ast_aud		
									(	site_cd, 						mst_rowid,					ast_aud_asset_no,					ast_aud_status,	
										ast_aud_originator,				ast_aud_start_date,			ast_aud_end_date,					ast_aud_duration,
										audit_user, 					audit_date,					mbl_audit_user,						mbl_audit_date)
							Values	(	?, 								?,							?,									?,
										?,								?,							NULL,								0,				
										?,								getdate(),					?,								getdate())";
									
									
		$params_insert_ast_aud = array(	$site_cd,						$ast_mst_rowid,				$ast_dwntime_asset_no,				$ast_dwntime_status_down,
										$EmpID,							$current_datetime,			
										$LogingID,						$LogingID);						
										
		$stmt_insert_ast_aud = sqlsrv_query( $conn, 	$sql_insert_ast_aud,	$params_insert_ast_aud);	
		
		if( !$stmt_insert_ast_aud ) {
			$error_message = "Error insert table (ast_aud)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}	
		sqlsrv_free_stmt($stmt_insert_ast_aud);	
	
		$sql_update_ast_dwntime = "Update ast_dwntime 
							Set ast_dwntime_status_up =?,
								ast_dwntime_rts_date = ?,
								ast_dwntime_downtime = ?,	
								ast_dwntime_up_wo=?,								
								ast_dwntime_repair_from = ?,
								ast_dwntime_repair_to = ?,
								ast_dwntime_repairtime = ?,
								ast_dwntime_remark=?,
								ast_dwntime_sched_flag=?,
								column1=?,
								audit_user = ?,
								audit_date = Getdate(),
								mbl_audit_user = ?, 
								mbl_audit_date = GetDate ()
						Where	rowid = ?";

		$params_update_ast_dwntime = array($ast_dwntime_status_up,$ast_dwntime_rts_date,	$ast_dwntime_downtime, $ast_dwntime_up_wo,	$ast_dwntime_repair_from, 	$ast_dwntime_repair_to, 	$ast_dwntime_repairtime, 	$ast_dwntime_remark,$ast_dwntime_sched_flag,$column1,$LogingID,$LogingID, $rowid);									
				
		$stmt_update_ast_dwntime = sqlsrv_query( $conn, $sql_update_ast_dwntime, $params_update_ast_dwntime);			
		
		if( !$stmt_update_ast_dwntime ) {
			$error_message = "Error update table (ast_dwntime)";
			returnError($error_message);
			die( print_r( sqlsrv_errors(), true));
		}
		sqlsrv_free_stmt( $stmt_update_ast_dwntime);
	}
}

//End 

//Check stmt and commit
If (!empty($ast_dwntime_status_down) && !empty($ast_dwntime_status_up) && !empty($ast_dwntime_status_up_before)){
	if($stmt_update_ast_dwntime){
 
		sqlsrv_commit( $conn );
		sqlsrv_close( $conn);	
		returnData();
	 
	 }else{
		sqlsrv_rollback( $conn );
		$error_message = "Transaction rolled back.<br />";
		returnError($error_message);
	 }
}else{
	if (!empty($ast_dwntime_status_down) && !empty($ast_dwntime_status_up) && empty($ast_dwntime_status_up_before)){
		if($stmt_update_asset && $stmt_get_aud_rowid && $stmt_update_ast_aud && $stmt_insert_ast_aud && $stmt_update_ast_dwntime){
	 
			sqlsrv_commit( $conn );
			sqlsrv_close( $conn);	
			returnData();
		 
		 }else{
			sqlsrv_rollback( $conn );
			$error_message = "Transaction rolled back.<br />";
			returnError($error_message);
		 }
	}	
 }
 
 
function returnData(){
	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Asset downtime update successfully');
	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}



 
 
?>