<?php

require_once('config.php');
require_once ('f_logging.php');
$error_message;
$valid = true;
$now = date("Ymdhisa");
$file_name = __DIR__ . "\mobile_log\_inventory_stock_take.log";

$itm_rcb_completed_by = $_GET['itm_rcb_completed_by'];
$LOGINID = $_GET['LOGINID'];

// Takes raw data from the request
$json = file_get_contents('php://input');
// Converts it into a PHP object
$data = json_decode($json);

foreach ($data->Header as $Header)
{
	
	$itemcount = $Header->itm_rcf_item_count;
	$rowid = $Header->rowid;
	$site_cd = $Header->site_cd;
	$count_book = $Header->itm_rcf_book_no;
	$remark = $Header->itm_rcf_remark;
	
	
	$sql1 = "UPDATE itm_rcf 
			SET 	itm_rcf_item_count = ? ,
					itm_rcf_remark = ?
			WHERE 	RowID = ?
			And 	itm_rcf.site_cd = ?";

	$params_sql1 = array($itemcount,$remark,$rowid,$site_cd);

	$stmt1 = sqlsrv_query( $conn, $sql1,$params_sql1);

	if ($stmt1 === false)
	{
		if (($errors = sqlsrv_errors()) != null)
		{
			foreach ($errors as $error)
			{

				file_put_contents($file_name, $now . "\r\n" . $sql1 . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
			}
		}
		sqlsrv_rollback($conn);
		sqlsrv_close($conn);

		$error_message = "(".$now.") Error updating table (itm_rcf)";
		returnError($error_message);
	}
	sqlsrv_free_stmt($stmt1);
	
	$sql2 = "update itm_rcb 
			 SET 	itm_rcb_item_count = (Select Count(*) From itm_rcf Where itm_rcf.itm_rcf_book_no = ? 
			And 	itm_rcf_item_count IS NOT NULL And itm_rcf.site_cd = ?), 
					itm_rcb_count_flag ='1' , 
					itm_rcb_count_date = GetDate ( ),
					mbl_audit_user= ?,		
					mbl_audit_date=getdate()				
			WHERE 	itm_rcb.site_cd = ? 
			AND 	itm_rcb.itm_rcb_book_no = ?";

	$params_sql2 = array($count_book,$site_cd,$LOGINID,$site_cd,$count_book);

	$stmt2 = sqlsrv_query( $conn, $sql2,$params_sql2);
	
	if ($stmt2 === false)
	{
		if (($errors = sqlsrv_errors()) != null)
		{
			foreach ($errors as $error)
			{

				file_put_contents($file_name, $now . "\r\n" . $sql2 . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
			}
		}
		sqlsrv_rollback($conn);
		sqlsrv_close($conn);

		$error_message = "(".$now.") Error updating table (itm_rcb)";
		returnError($error_message);
	}
	sqlsrv_free_stmt($stmt2);
	
		$sql3 = "UPDATE itm_rcb 
				SET itm_rcb_completed = 1,
				itm_rcb_completed_by = ?
				WHERE itm_rcb.site_cd = ?
				AND itm_rcb.itm_rcb_book_no = ?
				AND itm_rcb_total_item = (	SELECT COUNT(*) FROM itm_rcf 
											WHERE itm_rcb.site_cd = itm_rcf.site_cd 
											AND itm_rcb.itm_rcb_book_no = itm_rcf.itm_rcf_book_no 
											AND itm_rcf_item_count IS NOT NULL 
										  )";

				//echo $itm_rcb_completed_by;
				//echo $sql;
				
		$params_sql3 = array($itm_rcb_completed_by,$site_cd,$count_book);
		$stmt3 = sqlsrv_query( $conn, $sql3,$params_sql3);
		
		if ($stmt3 === false)
		{
			if (($errors = sqlsrv_errors()) != null)
			{
				foreach ($errors as $error)
				{

					file_put_contents($file_name, $now . "\r\n" . $sql2 . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
				}
			}
			sqlsrv_rollback($conn);
			sqlsrv_close($conn);

			$error_message = "(".$now.") Error updating table (itm_rcb)";
			returnError($error_message);
		}
		sqlsrv_free_stmt($stmt3);

	
}



if ($valid) {
	
	sqlsrv_close( $conn);	
	returnData();	
}

function returnData(){
	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Stock take update successfully');
	
	echo json_encode($returnData);
}

function returnError($error_message){
	$json = array();
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);
	
	echo json_encode($returnData);		
	exit();
}

?>