<?php
require_once('config.php');

$error_message = '';
$valid = true;

// Start transaction
if (sqlsrv_begin_transaction($conn) === false) {
    die(print_r(sqlsrv_errors(), true));
}

$site_cd = $_REQUEST['site_cd'];
$Rowid = $_REQUEST['Rowid'];

// Prepare SQL query with parameterized inputs
$sql = "
    SELECT 
        material_count 			= (SELECT COUNT(*) FROM wko_ls2 (NOLOCK) WHERE wko_ls2.site_cd = ? AND wko_ls2.mst_rowid = ?),
        Special_order_count 	= (SELECT COUNT(*) FROM wko_ls3 (NOLOCK) WHERE wko_ls3.site_cd = ? AND wko_ls3.mst_rowid = ?),
        Contract_count 			= (SELECT COUNT(*) FROM wko_ls4 (NOLOCK) WHERE wko_ls4.site_cd = ? AND wko_ls4.mst_rowid = ?),
        MISC_count 				= (SELECT COUNT(*) FROM wko_ls5 (NOLOCK) WHERE wko_ls5.site_cd = ? AND wko_ls5.mst_rowid = ?),
        Time_Card_count 		= (SELECT COUNT(*) FROM wko_ls8 (NOLOCK) WHERE wko_ls8.site_cd = ? AND wko_ls8.mst_rowid = ?),
        Asset_downtime_count 	= (SELECT COUNT(*) FROM ast_dwntime (NOLOCK) WHERE ast_dwntime.site_cd = ? AND ast_dwntime.mst_rowid = ?),
        Check_list_count 		= (SELECT COUNT(*) FROM wko_isp (NOLOCK) WHERE wko_isp.site_cd = ? AND wko_isp.mst_rowid = ?)
    FROM wko_mst  (NOLOCK) 
    WHERE wko_mst.site_cd = ? AND wko_mst.RowID = ?
";

// Prepare and execute the query
$params = array($site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid, $site_cd, $Rowid);
$stmt = sqlsrv_query($conn, $sql, $params);

if (!$stmt) {
    $error_message = "Error SELECT Table (wko_mst)";
    returnError($error_message);
    die(print_r(sqlsrv_errors(), true));
}

$not_allowed = false;

// Fetch the results and check if any of the counts are greater than 0
if ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
   
    // Check if any count is greater than 0
    if ($row['material_count'] > 0 || $row['Special_order_count'] > 0 || $row['Contract_count'] > 0 || 
        $row['MISC_count'] > 0 || $row['Time_Card_count'] > 0 || $row['Asset_downtime_count'] > 0 || 
        $row['Check_list_count'] > 0) {
        $not_allowed = true;
    }
}

if ($not_allowed) {
    sqlsrv_rollback($conn); // Rollback transaction
    returnError("You are not allowed to change the asset number beacuse the planning already exist.");
} else {
    if ($stmt) {
        sqlsrv_commit($conn); // Commit transaction
        sqlsrv_close($conn);  // Close connection
        returnData();
    } else {
        sqlsrv_rollback($conn); // Rollback transaction
        $error_message = "Transaction rolled back.<br />";
        returnError($error_message);
    }
}

// Function to return success data
function returnData() {
    $returnData = array(
        'status' => 'SUCCESS',
        'message' => 'Successfully'
    );
    echo json_encode($returnData);
}

// Function to return an error message
function returnError($error_message) {
    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message
    );
    echo json_encode($returnData);
    exit();
}

?>
