<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With" );

// get these values from your DB.
require_once('config.php');
require_once('f_get_emp_ls5.php');
$error_message;
$valid = true;

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}


$site_cd = $_REQUEST['site_cd'];
$wko_sts_wo_no=$_REQUEST['wko_sts_wo_no'];

$sql="	select 	wko_sts.site_cd,
				mst_RowID,
				wko_sts_wo_no,
				wko_sts_originator	= COALESCE(wko_sts_originator +' : ' +emp_mst.emp_mst_name,''),
				wko_sts_status	= COALESCE(wko_sts_status +' : '+wrk_sts.wrk_sts_desc,''),
				wko_sts_start_date,
				wko_sts_end_date,
				wko_sts_duration	
				
		from wko_sts 
		INNER JOIN	wrk_sts (NOLOCK)
		ON			wko_sts.site_cd = wrk_sts.site_cd
		AND			wko_sts.wko_sts_status = wrk_sts.wrk_sts_status

		LEFT 
		OUTER 
		JOIN		emp_mst (NOLOCK)						
		ON			wko_sts.site_cd = emp_mst.site_cd
		AND			wko_sts.wko_sts_originator = emp_mst.emp_mst_empl_id

		WHERE		wko_sts.site_cd = '".$site_cd."'
		AND 		wko_sts.wko_sts_wo_no ='".$wko_sts_wo_no."' order by wko_sts.RowID asc";

$stmt_wko_sts = sqlsrv_query( $conn, $sql);

if( !$stmt_wko_sts ) {
	 $error_message = "Error selecting table (emp_mst)";
	 returnError($error_message);
	 die( print_r( sqlsrv_errors(), true));
	 
}

$json = array();

do {
	 while ($row = sqlsrv_fetch_array($stmt_wko_sts, SQLSRV_FETCH_ASSOC)) {		
		$json[] = $row;	
	
	 }
} while ( sqlsrv_next_result($stmt_wko_sts) );




if( $stmt_wko_sts) {
		 sqlsrv_commit( $conn );
		 sqlsrv_close( $conn);	
		 returnData($json);	
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
} 



function returnData($json){
	 $json1 = json_encode($json);
	 //echo$json;
	 
	 if(empty(json_decode($json1,1))) {
     $returnData = array(
	'status' => 'SUCCESS',
	'message' => 'No Records found ',	
	'data' => $json);
}else{
	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Successfully',
	'data' => $json);
} 	
	
	echo json_encode($returnData);
}

function returnError($error_message){
	$json = array();
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message,
	'data' => $json);
	
	echo json_encode($returnData);
	exit();
		
}
	

 
?>