<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
require_once('config.php');
require_once('f_error_log.php');

function send_email($site_cd, $eml_log_from, $eml_log_to_email, $title, $body, $audit_user, $doc_no, $module, $action, $trigger_from, $parm1, $parm2, $parm3){
	global $conn;
	global $directory;
	
	$now = date("Ymdhisa");
	
	$from = "";
	$to = "";
	$cc = Null;	
	
	//PR Approved, WO Completion, 
	$event = $action;
	
	//The mail had been successfully sent.
	//The mail had been successfully sent to the queue.
	$email_status_msg = 'The mail had been successfully sent to the queue.';
	
	//P - Pending, S - Sent, E - Error
	$email_status = 'P';
	
	//Core, Webwork, Mobile
	$trigger_from = 'Mobile';
	
	$insert_email = true;
	
	//Get From Email by Empl ID
	$sql_get_emp_name = "Select emp_mst_name
			From 	emp_mst (NOLOCK), emp_det (NOLOCK)
			Where 	emp_mst.site_cd ='" . $site_cd . "'
			AND		emp_mst.site_cd = emp_det.site_cd
			AND		emp_mst.rowid = emp_det.mst_rowid
			AND		emp_mst_empl_id = '".$eml_log_from."'";
			
	$stmt_get_emp_name = sqlsrv_query($conn, $sql_get_emp_name);

	if ($stmt_get_emp_name === false)
	{
		$error_message = "Error selecting table (emp_mst, emp_det) - ".$now;
		if (($errors = sqlsrv_errors()) != null)
		{
			foreach ($errors as $error)
			{
				//file_put_contents($file_name, $now . "\r\n" . $sql_wo_detail . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
				insert_error_log($site_cd, $error['message'], $audit_user, $module, $action);
			}
		}
		
	}

	do
	{
		while ($row = sqlsrv_fetch_array($stmt_get_emp_name, SQLSRV_FETCH_ASSOC))
		{

			$from = $row['emp_mst_name'];
		}
	}
	while (sqlsrv_next_result($stmt_get_emp_name));
	sqlsrv_free_stmt($stmt_get_emp_name);
	
	
	if (empty($from) || $from == ""){
		$from = $eml_log_from;
	}
	
	//Get To Email by Empl ID
	$placeholders = implode(', ', array_fill(0, count($eml_log_to_email), '?'));
	
	$sql_get_emp_to_email = "Select distinct emp_det_email_id
			From 	emp_mst (NOLOCK), emp_det (NOLOCK)
			Where 	emp_mst.site_cd ='" . $site_cd . "'
			AND		emp_mst.site_cd = emp_det.site_cd
			AND		emp_mst.rowid = emp_det.mst_rowid
			AND		emp_mst_empl_id IN ($placeholders)";
			
			
	$stmt_get_emp_to_email = sqlsrv_query($conn, $sql_get_emp_to_email, $eml_log_to_email);

	if ($stmt_get_emp_to_email === false)
	{
		$error_message = "Error selecting table (emp_mst, emp_det) - ".$now;
		if (($errors = sqlsrv_errors()) != null)
		{
			foreach ($errors as $error)
			{
				//file_put_contents($file_name, $now . "\r\n" . $sql_wo_detail . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
				insert_error_log($site_cd, $error['message'], $audit_user, $module, $action);
			}
		}
	}

	do
	{
		while ($row = sqlsrv_fetch_array($stmt_get_emp_to_email, SQLSRV_FETCH_ASSOC))
		{
			$to = $to.$row['emp_det_email_id'].";";
		}
	}
	while (sqlsrv_next_result($stmt_get_emp_to_email));
	sqlsrv_free_stmt($stmt_get_emp_to_email);
	
	if (empty($to) || $to == ""){
		$to = $eml_log_to_email;
	}
	
	$subject = $title;
	$content = $body;
	
	

	
	$sql_insert_eml_log = "	INSERT Into eml_log (	site_cd,			eml_log_from,			eml_log_to_email,		eml_log_cc_email,		eml_log_subject,		eml_log_content,			
												eml_log_date, 			eml_log_event,			eml_log_msg,			eml_log_status,			audit_user,				audit_date,				
												column1,				eml_log_doc_no)					

							 VALUES 
											(	?,						?,						?,						?,						?,						?,						
												getdate(),				?,						?,						?,						?,						getdate(),				
												?,						?)" ;

	$params_insert_eml_log = array(				$site_cd,				$from,					$to,					$cc,					$subject,				$content,
																		$event,					$email_status_msg,		$email_status,			$audit_user,	
												$trigger_from,			$doc_no);
									
									

	$stmt_insert_eml_log = sqlsrv_query( $conn, $sql_insert_eml_log, $params_insert_eml_log);	
	
	if( !$stmt_insert_eml_log ) {
		



		$error_message = "Error (INSERT Table eml_log)";
		if (($errors = sqlsrv_errors()) != null){
			foreach ($errors as $error)	{
				//echo $error['message'];
				//file_put_contents($file_name, $now . "\r\n" . $sql_wo_detail . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
				insert_error_log($site_cd, $error['message'], $audit_user, $module, $action);
			}
		}
	
		$insert_email = false;
		
	}
	sqlsrv_free_stmt($stmt_insert_eml_log);
	
	$sql_exe_sp = "EXEC sp_send_email_mobile";

	$stmt_exe_sp = sqlsrv_query( $conn, $sql_exe_sp);
	
	if( !$stmt_exe_sp ) {
		$error_message = "Error (Execure sp_send_email)";
		if (($errors = sqlsrv_errors()) != null){
			foreach ($errors as $error)	{
				//echo $error['message'];
				// file_put_contents($file_name, $now . "\r\n" . $sql_wo_detail . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
				//insert_error_log($site_cd, $error['message'], $audit_user, $module, $action);
			}
		}
	}
		
	return $insert_email;
}


?>