<?php
require_once ('config.php');


$error_message;
$valid = true;
$now = date("Ymdhisa");
$file_name = __DIR__ . "\mobile_log\_update_workrequest.log";

/* Begin the transaction. */
if (sqlsrv_begin_transaction($conn) === false)
{
    die(print_r(sqlsrv_errors() , true));
}

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$EmpID = $data['EmpID'];
$EmpName = $data['EmpName'];

$wkr_mst_originator 	= !empty($data['wkr_mst_originator']) ? $data['wkr_mst_originator'] : null;
$wkr_mst_phone 			= !empty($data['wkr_mst_phone']) ? $data['wkr_mst_phone'] : null;

$wkr_mst_assetno = $data['wkr_mst_assetno'];

$mst_war_work_area 		= !empty($data['mst_war_work_area']) ? $data['mst_war_work_area'] : null;
$wkr_mst_assetlocn 		= !empty($data['wkr_mst_assetlocn']) ? $data['wkr_mst_assetlocn'] : null;
$wkr_mst_location 		= !empty($data['ast_mst_asset_lvl']) ? $data['ast_mst_asset_lvl'] : null;


$wkr_mst_wr_no = $data['wkr_mst_wr_no'];
$wkr_mst_chg_costcenter = !empty($data['wkr_mst_chg_costcenter']) ? $data['wkr_mst_chg_costcenter'] : null;
$wkr_mst_orig_priority 	= !empty($data['wkr_mst_orig_priority']) ? $data['wkr_mst_orig_priority'] : null;

$wkr_mst_org_date = $data['wkr_mst_org_date'];
$wkr_mst_due_date = $data['wkr_mst_due_date'];

$wkr_mst_fault_code 	= !empty($data['wkr_mst_fault_code']) ? $data['wkr_mst_fault_code'] : null;
$wkr_mst_work_group 	= !empty($data['wkr_mst_work_group']) ? $data['wkr_mst_work_group'] : null;
$wkr_mst_wr_descs 		= !empty($data['wkr_mst_wr_descs']) ? $data['wkr_mst_wr_descs'] : null;
$wkr_mst_work_type 		= !empty($data['wkr_mst_work_type']) ? $data['wkr_mst_work_type'] : null;
$wkr_mst_work_class 	= !empty($data['wkr_mst_work_class']) ? $data['wkr_mst_work_class'] : null;


$ROW_ID = $data['RowID'];
$LOGINID = $data['LOGINID'];

$sq_wkr_mst = "UPDATE  	wkr_mst  SET							
						wkr_mst_originator=?,			wkr_mst_phone=?,				wkr_mst_assetlocn=?,			
						wkr_mst_assetno=?,				wkr_mst_fault_code=?,			wkr_mst_org_date=?,
						wkr_mst_due_date=?,				wkr_mst_chg_costcenter=?,		wkr_mst_work_area=?,				
						wkr_mst_location=?,				wkr_mst_orig_priority=?,		wkr_mst_wr_descs =?,	
						wkr_mst_work_group =?,			wkr_mst_work_type=?,			wkr_mst_work_class=?,
						audit_user=?,					audit_date=GETDATE(),			mbl_audit_user=?,				mbl_audit_date=GETDATE()						
				where 	site_cd = ?
				AND		wkr_mst_wr_no = ?	
				AND		RowID = ?";

//echo $sql;
$params_wkr_mst = array($wkr_mst_originator,			$wkr_mst_phone,					$wkr_mst_assetlocn,
						$wkr_mst_assetno,				$wkr_mst_fault_code,			$wkr_mst_org_date,
						$wkr_mst_due_date,				$wkr_mst_chg_costcenter,		$mst_war_work_area,
						$wkr_mst_location,				$wkr_mst_orig_priority,			$wkr_mst_wr_descs,
						$wkr_mst_work_group,			$wkr_mst_work_type,				$wkr_mst_work_class,
						$LOGINID,						$LOGINID,						$site_cd,						
						$wkr_mst_wr_no,					$ROW_ID);

$stmt_wkr_mst = sqlsrv_query($conn, $sq_wkr_mst, $params_wkr_mst);

if ($stmt_wkr_mst === false)
{
    if (($errors = sqlsrv_errors()) != null)
    {
        foreach ($errors as $error)
        {

            file_put_contents($file_name, $now . "\r\n" . $sq_wkr_mst . "\r\n" . "SQLSTATE: " . $error['SQLSTATE'] . "\r\n" . "code: " . $error['code'] . "\r\n" . "message: " . $error['message'] . "\r\n\r\n", FILE_APPEND);
        }
    }
    sqlsrv_rollback($conn);
    sqlsrv_close($conn);

    $error_message = "(".$now.") Error updating table (wkr_mst)";
    returnError($error_message);
}
sqlsrv_free_stmt($stmt_wkr_mst);

if ($stmt_wkr_mst)
{
    sqlsrv_commit($conn);
    sqlsrv_close($conn);
    returnData($ROW_ID, $wkr_mst_wr_no);
}

function returnData($ROW_ID, $wkr_mst_wr_no)
{
    $returnData = array(
        'status' => 'SUCCESS',
        'ROW_ID' => $ROW_ID,
        'message' => 'Work request no ' . $wkr_mst_wr_no . ' update successfully.'
    );

    echo json_encode($returnData);
}

function returnError($error_message)
{

    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message
    );
    echo json_encode($returnData);
	exit();
}

?>
