<?php
// get these values from your DB.
require_once('config.php');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods:  POST");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

try {
	
	$json = file_get_contents('php://input');
	// Converts it into a PHP object
	$data = json_decode($json, true);
	
	$site_cd 					= $data['site_cd'];
	$wkr_mst_wr_no 				= $data['wkr_mst_wr_no'];
	$wkr_mst_work_group 		= $data['wkr_mst_work_group'];
	$wkr_mst_approved 			= $data['wkr_mst_approved'];
	$wkr_mst_capital_project 	= $data['wkr_mst_capital_project'];
	$wkr_mst_temp_asset 		= $data['wkr_mst_temp_asset'];
	$emp_id 					= $data['emp_id'];
	
	
	$sql_emp_mst="Select emp_det_work_grp,
						emp_det_ira_idno,
						emp_det_work_area,
						emp_det_liability_acc,
						emp_det_eth,
						emp_det_purch_person,
						emp_det_wr_approver,
						emp_det_contractor
			From		emp_mst (NOLOCK), emp_det (NOLOCK)
			Where 	emp_mst.site_cd = emp_det.site_cd
			And		emp_mst.rowid = emp_det.mst_rowid
			And		emp_mst.site_cd = '".$site_cd."'
			And		emp_mst.emp_mst_empl_id = '".$emp_id."'" ;
			
	$stmt_emp_mst = sqlsrv_query( $conn, $sql_emp_mst);
	if( !$stmt_emp_mst ) {
		 $error_message = "Error selecting table (emp_mst)";
		 returnError($error_message);
		 die( print_r( sqlsrv_errors(), true));
		 
	}
	do{
		
		while ($row = sqlsrv_fetch_array($stmt_emp_mst, SQLSRV_FETCH_ASSOC)) {
			$is_wrk_grp1 			= $row['emp_det_work_grp'];
			$is_wrk_grp2 			= $row['emp_det_ira_idno'];
			$is_wrk_grp3 			= $row['emp_det_work_area'];
			$is_wrk_grp4			= $row['emp_det_liability_acc'];
			$emp_det_eth			= $row['emp_det_eth'];
			$emp_det_purch_person 	= $row['emp_det_purch_person'];
			$emp_det_contractor 	= $row['emp_det_contractor'];
			$emp_det_wr_approver 	= $row['emp_det_wr_approver'];
		}
		
	}while ( sqlsrv_next_result($stmt_emp_mst) );
	
	if (preg_match('/^([A-Za-z]+)/', $wkr_mst_wr_no, $matches)) {
		$prefix = $matches[1]; // Extract the first group of letters

		if ($prefix == 'PJR' || $prefix == 'PR') {
			
			if($wkr_mst_temp_asset == '0'){
				 throw new Exception("The Request must be review first before it can be approve.");
			}else if($wkr_mst_capital_project =='1' && $wkr_mst_approved == '0' ){
				throw new Exception("The Request must be review by the higher level first before it can be approve.");
			} else if($emp_det_eth =='0'){
				throw new Exception("You Do Not Have the Permission to Perform The Approval.Please Contact the Administrator.");
			}else{
				
				// Free the statement and close the connection
				sqlsrv_free_stmt($stmt_emp_mst);
				sqlsrv_close($conn);
				// Return the fetched data
				returnData();
				
				
			} 
				
			
		}else if($prefix == 'MPR' || $prefix == 'FM'){
			
			if($emp_det_contractor == '0'){
				 throw new Exception("You Do Not Have the Permission to Perform The Fabrication Approval.Please Contact the Administrator.");
			}else if($wkr_mst_temp_asset =='0'){
				throw new Exception("The Work Request must be review before it can be approve.");
			} elseif (!($is_wrk_grp1 == "" && $is_wrk_grp2 == "" && $is_wrk_grp3 == "" && $is_wrk_grp4 == "") &&
					  !($is_wrk_grp1 == $wkr_mst_work_group || $is_wrk_grp2 == $wkr_mst_work_group || 
					  $is_wrk_grp3 == $wkr_mst_work_group || $is_wrk_grp4 == $wkr_mst_work_group)) {
						  
				throw new Exception("You Do Not Have the Permission to Perform The Fabrication Approval For This Work Group ".( $wkr_mst_work_group )." Please Contact the Administrator.");
			}else{
				
				// Free the statement and close the connection
				sqlsrv_free_stmt($stmt_emp_mst);
				sqlsrv_close($conn);
				// Return the fetched data
				returnData();
			} 
			
		}else{
			
			if($emp_det_wr_approver == '0'){
				throw new Exception("You Do Not Have the Permission to Perform The Approval.Please Contact the Administrator.");
			}else if($wkr_mst_temp_asset =='0'){
				throw new Exception("The Work Request must be review before it can be approve.");
			} elseif (!($is_wrk_grp1 == "" && $is_wrk_grp2 == "" && $is_wrk_grp3 == "" && $is_wrk_grp4 == "") &&
					  !($is_wrk_grp1 == $wkr_mst_work_group || $is_wrk_grp2 == $wkr_mst_work_group || 
					  $is_wrk_grp3 == $wkr_mst_work_group || $is_wrk_grp4 == $wkr_mst_work_group)) {
						  
				throw new Exception("You Do Not Have the Permission to Perform The Approval For This Work Group ".( $wkr_mst_work_group )." Please Contact the Administrator.");
			}else{
				
				// Free the statement and close the connection
				sqlsrv_free_stmt($stmt_emp_mst);
				sqlsrv_close($conn);
				// Return the fetched data
				returnData();
			} 
			
		}
	}
	
	

}catch (Exception $e) {
    // Handle any exceptions
    $error_message = $e->getMessage();
    returnError($error_message);
}

function returnData() {
    $returnData = array(
        'status' => 'SUCCESS',
		'message' => 'Successfully'
    );

    echo json_encode($returnData);    
}


function returnError($error_message) {
    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message
    );
    echo json_encode($returnData);
    exit();    
}
 
?>