<?php
// Include the database configuration file
require_once('config.php');


try {
    // SQL query to fetch data
    $sql = "SELECT  site_cd, site_name FROM cf_site (NOLOCK) WHERE disable_flag = '0' order by site_cd";
    
    // Execute the query
    $stmt = sqlsrv_query($conn, $sql);
    
    // Check for errors in the query execution
    if (!$stmt) {
        throw new Exception("Error selecting table (cf_site): " . print_r(sqlsrv_errors(), true));
    }
    
    // Initialize an array to hold the result
    $json = array();
    
    // Fetch data from the result set
    while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
        $json[] = $row;
    }
    
	//echo json_encode($json);
    // Free the statement and close the connection
    sqlsrv_free_stmt($stmt);
    sqlsrv_close($conn);
    
    // Return the fetched data
    returnData($json);
    
} catch (Exception $e) {
    // Handle any exceptions
    $error_message = $e->getMessage();
    returnError($error_message);
}

function returnData($json) {
    $returnData = array(
        'status' => 'SUCCESS',
        'data' => $json
    );
    
    echo json_encode($returnData);
}

function returnError($error_message) {
    $json = array();
    
    $returnData = array(
        'status' => 'ERROR',
        'message' => $error_message,
        'data' => $json
    );
    
    echo json_encode($returnData);
    exit();
}
?>
