<?php
require_once('config.php');


// Get site_cd from request
$site_cd = $_REQUEST['site_cd'];

// Prepare SQL query
$sql = "SELECT 
            dft_mst_wko_sts = COALESCE(dft_mst_wko_sts + ' : ' + wrk_sts_desc,''), 
            dft_mst_lab_act = COALESCE(dft_mst_lab_act,''), 
            dft_mst_mat_act = COALESCE(dft_mst_mat_act,''), 
            dft_mst_con_act = COALESCE(dft_mst_con_act,''), 
            dft_mst_wko_pri = COALESCE(dft_mst_wko_pri + ' : ' + wrk_pri_desc + ' - ' + cast(wrk_pri_due_date_count as varchar),''), 
            dft_mst_temp_ast , 
            dft_mst_wko_asset_no = COALESCE(dft_mst_wko_asset_no,''), 
            dft_mst_wkr_asset_no = COALESCE(dft_mst_wkr_asset_no,'') ,
            dft_mst_wo_default_cc , 
            dft_mst_time_card_by , 
            dft_mst_itm_resv, 
            dft_mst_po_auto_close,
            dft_mst_mr_approval , 
            dft_mst_mtr_email_approver , 
            dft_mst_tim_act = COALESCE(dft_mst_tim_act,''),
            dft_mst_gen_inv,
            dft_mst_mbl_chk_cmp,
            dft_mst_mbl_chk_scan,
            dft_mst_pur_email_approver,
            dft_mst_pur_email_requestor,
            dft_mst_generate_po,
			dft_mst_edit_wo_date,
			dft_mst_edit_wr_date,
			dft_mst_mbl_single_login,
			dft_mst_cm_req_cmp,
			dft_mst_pm_req_cmp,
			dft_mst_openai,
			dft_mst_wo_camera_act,
			dft_mst_dft_wo_appr_status = COALESCE(dft_mst_dft_wo_appr_status,''),
            cf_site.site_name
        FROM dft_mst (NOLOCK) 
        LEFT OUTER JOIN wrk_pri (NOLOCK) ON dft_mst.site_cd = wrk_pri.site_cd AND dft_mst.dft_mst_wko_pri = wrk_pri.wrk_pri_pri_cd 
        LEFT OUTER JOIN wrk_sts (NOLOCK) ON dft_mst.site_cd = wrk_sts.site_cd AND dft_mst.dft_mst_wko_sts = wrk_sts.wrk_sts_status 
        LEFT OUTER JOIN cf_site (NOLOCK) ON dft_mst.site_cd = cf_site.site_cd
        WHERE dft_mst.site_cd = ?";

// Initialize connection and statement
$conn = sqlsrv_connect($_serverName, $connectionInfo);
if (!$conn) {
    $error_message = "Database connection failed: " . print_r(sqlsrv_errors(), true);
    returnError('Error', $error_message);
}

$params = array($site_cd);
$stmt = sqlsrv_query($conn, $sql, $params);

if (!$stmt) {
    $error_message = "Error executing query: " . print_r(sqlsrv_errors(), true);
    returnError('Error', $error_message);
}

$Defaultvalue = array();

// Fetch data
while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
    $Defaultvalue[] = $row;
}

// Free statement and close connection
sqlsrv_free_stmt($stmt);
sqlsrv_close($conn);

// Return data
returnData('SUCCESS', 'Successfully', $Defaultvalue);

function returnData($status, $message, $data) {
    $returnData = array(
        'status' => $status,
        'message' => $message,
        'data' => $data
    );
    echo json_encode($returnData);
    exit();
}

function returnError($status, $error_message) {
    $returnData = array(
        'status' => $status,
        'message' => $error_message,
        'data' => ''
    );
    echo json_encode($returnData);
    exit();
}
?>
