<?php
require_once('config.php');

$error_message;
$valid = true;

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$rowid = $data['rowid'];
$slc_mst_status = $data['slc_mst_status'];
$slc_mst_slc_date = $data['slc_mst_slc_date'];
$slc_mst_weg_date = $data['slc_mst_weg_date'];
$slc_mst_weg_by = $data['slc_mst_weg_by'];
$slc_mst_weg_designation = $data['slc_mst_weg_designation'];
$slc_mst_ver_date = $data['slc_mst_ver_date'];
$slc_mst_ver_by = $data['slc_mst_ver_by'];
$slc_mst_ver_designation = $data['slc_mst_ver_designation'];
$slc_mst_remark = $data['slc_mst_remark'];
$LOGINID = $data['LOGINID'];


$sql="UPDATE slc_mst SET							
			slc_mst_status=?,		
			slc_mst_slc_date=?,		
			slc_mst_weg_date=?,			
			slc_mst_weg_by=?,		
			slc_mst_weg_designation=?,			
			slc_mst_ver_date=?,
			slc_mst_ver_by=?,
			slc_mst_ver_designation=?,
			slc_mst_remark=?,
			audit_user=?,
			audit_date=getdate()
		WHERE site_cd=? 
		AND rowid=?";	
				
	//echo $sql;
	$params = array($slc_mst_status,	$slc_mst_slc_date,	$slc_mst_weg_date,	$slc_mst_weg_by,	$slc_mst_weg_designation,	$slc_mst_ver_date, $slc_mst_ver_by,	$slc_mst_ver_designation, $slc_mst_remark, $LOGINID, $site_cd, $rowid);					
						
	$stmt = sqlsrv_query( $conn, $sql, $params);

	if( !$stmt ) {
		$error_message = "Error UPDATE Table (slc_mst)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt) );
	sqlsrv_free_stmt( $stmt);	


if( $stmt) {
	 sqlsrv_commit( $conn );
	 sqlsrv_close( $conn);	
	 returnData($json);		
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
}

function returnData($json){
	
	$json1 = json_encode($json);

	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Successfully',	
	'data' => $json);

	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}

 
?>