<?php
require_once('config.php');

$error_message;
$valid = true;

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$RowID = $data['rowid'];
$mst_RowID = $data['mst_RowID'];
$jni_ls1_floor = $data['jni_ls1_floor'];
$jni_ls1_wall = $data['jni_ls1_wall'];
$jni_ls1_ceiling = $data['jni_ls1_ceiling'];
$jni_ls1_window_door = $data['jni_ls1_window_door'];
$jni_ls1_receptacle_container = $data['jni_ls1_receptacle_container'];
$jni_ls1_furniture_fixture_equipment = $data['jni_ls1_furniture_fixture_equipment'];
$jni_ls1_remark = $data['jni_ls1_remark'];

$LOGINID = $data['LOGINID'];

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}

$sql="UPDATE jni_ls1 SET							
			jni_ls1_floor=?,		
			jni_ls1_wall=?,		
			jni_ls1_ceiling=?,			
			jni_ls1_window_door=?,		
			jni_ls1_receptacle_container=?,			
			jni_ls1_furniture_fixture_equipment=?,
			jni_ls1_remark=?,
			audit_user=?,
			audit_date=getdate()
			WHERE site_cd=? 
			AND RowID=?";	
				
	//echo $sql;
	$params = array($jni_ls1_floor,$jni_ls1_wall,$jni_ls1_ceiling,$jni_ls1_window_door,$jni_ls1_receptacle_container,$jni_ls1_furniture_fixture_equipment, $jni_ls1_remark, $LOGINID, $site_cd, $RowID);					
						
	$stmt = sqlsrv_query( $conn, $sql,$params);

	if( !$stmt ) {
		$error_message = "Error SELECT Table (jni_ls1)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt) );
	sqlsrv_free_stmt( $stmt);	
	
	
	
$sql_getcount = "SELECT 
				Count_yes_floor = sum (CASE When jni_ls1_floor = 'Yes' Then 1 Else 0 End),
				Count_yes_wall = sum (CASE When jni_ls1_wall = 'Yes' Then 1 Else 0 End),
				Count_yes_ceiling = sum (CASE When jni_ls1_ceiling = 'Yes' Then 1 Else 0 End),
				Count_yes_window_door = sum (CASE When jni_ls1_window_door = 'Yes' Then 1 Else 0 End),
				Count_yes_receptacle_container = sum (CASE When jni_ls1_receptacle_container = 'Yes' Then 1 Else 0 End),
				Count_yes_furniture_fixture_equipment = sum (CASE When jni_ls1_furniture_fixture_equipment = 'Yes' Then 1 Else 0 End),
				
				Count_no_floor = sum (CASE When jni_ls1_floor = 'No' Then 1 Else 0 End),
				Count_no_wall = sum (CASE When jni_ls1_wall = 'No' Then 1 Else 0 End),
				Count_no_ceiling = sum (CASE When jni_ls1_ceiling = 'No' Then 1 Else 0 End),
				Count_no_window_door = sum (CASE When jni_ls1_window_door = 'No' Then 1 Else 0 End),
				Count_no_receptacle_container = sum (CASE When jni_ls1_receptacle_container = 'No' Then 1 Else 0 End),
				Count_no_furniture_fixture_equipment = sum (CASE When jni_ls1_furniture_fixture_equipment = 'No' Then 1 Else 0 End),
				
				Count_na_floor = sum (CASE When jni_ls1_floor = 'Not Applicable' Then 1 Else 0 End),
				Count_na_wall = sum (CASE When jni_ls1_wall = 'Not Applicable' Then 1 Else 0 End),
				Count_na_ceiling = sum (CASE When jni_ls1_ceiling = 'Not Applicable' Then 1 Else 0 End),
				Count_na_window_door = sum (CASE When jni_ls1_window_door = 'Not Applicable' Then 1 Else 0 End),
				Count_na_receptacle_container = sum (CASE When jni_ls1_receptacle_container = 'Not Applicable' Then 1 Else 0 End),
				Count_na_furniture_fixture_equipment = sum (CASE When jni_ls1_furniture_fixture_equipment = 'Not Applicable' Then 1 Else 0 End),
				
				Count_st_floor = sum (CASE When jni_ls1_floor = 'Stubborn Stain' Then 1 Else 0 End),
				Count_st_wall = sum (CASE When jni_ls1_wall = 'Stubborn Stain' Then 1 Else 0 End),
				Count_st_ceiling = sum (CASE When jni_ls1_ceiling = 'Stubborn Stain' Then 1 Else 0 End),
				Count_st_window_door = sum (CASE When jni_ls1_window_door = 'Stubborn Stain' Then 1 Else 0 End),
				Count_st_receptacle_container = sum (CASE When jni_ls1_receptacle_container = 'Stubborn Stain' Then 1 Else 0 End),
				Count_st_furniture_fixture_equipment = sum (CASE When jni_ls1_furniture_fixture_equipment = 'Stubborn Stain' Then 1 Else 0 End)
				
		FROM	jni_ls1
		WHERE	site_cd = '".$site_cd." '
		AND		mst_rowid = '".$mst_RowID."'";

$stmt_getcount = sqlsrv_query( $conn, $sql_getcount);

if( !$stmt_getcount ) {
     $error_message = "Error selecting table (Joint Inspection Get Count)";
	 returnError($error_message);
     die( print_r( sqlsrv_errors(), true));
}



do {
     while ($row = sqlsrv_fetch_array($stmt_getcount, SQLSRV_FETCH_ASSOC)) {
		 
				$Count_yes_floor = $row['Count_yes_floor'];
				$Count_yes_wall = $row['Count_yes_wall'];
				$Count_yes_ceiling = $row['Count_yes_ceiling'];
				$Count_yes_window_door = $row['Count_yes_window_door'];
				$Count_yes_receptacle_container = $row['Count_yes_receptacle_container'];
				$Count_yes_furniture_fixture_equipment = $row['Count_yes_furniture_fixture_equipment'];
				
				$Count_no_floor = $row['Count_no_floor'];
				$Count_no_wall = $row['Count_no_wall'];
				$Count_no_ceiling = $row['Count_no_ceiling'];
				$Count_no_window_door = $row['Count_no_window_door'];
				$Count_no_receptacle_container = $row['Count_no_receptacle_container'];
				$Count_no_furniture_fixture_equipment = $row['Count_no_furniture_fixture_equipment'];
				
				$Count_na_floor = $row['Count_na_floor'];
				$Count_na_wall = $row['Count_na_wall'];
				$Count_na_ceiling = $row['Count_na_ceiling'];
				$Count_na_window_door = $row['Count_na_window_door'];
				$Count_na_receptacle_container = $row['Count_na_receptacle_container'];
				$Count_na_furniture_fixture_equipment = $row['Count_na_furniture_fixture_equipment'];
				
				$Count_st_floor = $row['Count_st_floor'];
				$Count_st_wall = $row['Count_st_wall'];
				$Count_st_ceiling = $row['Count_st_ceiling'];
				$Count_st_window_door = $row['Count_st_window_door'];
				$Count_st_receptacle_container = $row['Count_st_receptacle_container'];
				$Count_st_furniture_fixture_equipment = $row['Count_st_furniture_fixture_equipment'];
		 
		
		
		 $SUM_Total_Yes = $Count_yes_floor + $Count_yes_wall + $Count_yes_ceiling + $Count_yes_window_door + $Count_yes_receptacle_container + $Count_yes_furniture_fixture_equipment;
		 $SUM_Total_No = $Count_no_floor + $Count_no_wall + $Count_no_ceiling + $Count_no_window_door + $Count_no_receptacle_container + $Count_no_furniture_fixture_equipment;
		 $SUM_Total_Na = $Count_na_floor + $Count_na_wall + $Count_na_ceiling + $Count_na_window_door + $Count_na_receptacle_container + $Count_na_furniture_fixture_equipment;
		 $SUM_Total_St = $Count_st_floor + $Count_st_wall + $Count_st_ceiling + $Count_st_window_door + $Count_st_receptacle_container + $Count_st_furniture_fixture_equipment;
		 $SUM_Total = $SUM_Total_Yes + $SUM_Total_No + $SUM_Total_Na + $SUM_Total_St;
		 
		 
		 
$sql_updateCount="UPDATE jni_mst SET							
			jni_mst_no_of_y=?,
			jni_mst_no_of_n=?,
			jni_mst_no_of_s=?,
			jni_mst_no_of_na=?,
			jni_mst_total=?,
			audit_user=?,
			audit_date=getdate()
			WHERE site_cd=? 
			AND RowID=?";	
				
	//echo $sql;
	$params_updateCount = array($SUM_Total_Yes,$SUM_Total_No,$SUM_Total_St,$SUM_Total_Na,$SUM_Total,$LOGINID, $site_cd, $mst_RowID);					
						
	$stmt_updateCount = sqlsrv_query( $conn, $sql_updateCount,$params_updateCount);

	if( !$stmt_updateCount ) {
		$error_message = "Error SELECT Table (jni_ls1)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt_updateCount, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt_updateCount) );
	sqlsrv_free_stmt( $stmt_updateCount);	
	
		 
		
    
     }
} while ( sqlsrv_next_result($stmt_getcount) );





if( $stmt) {
	 sqlsrv_commit( $conn );
	 sqlsrv_close( $conn);	
	 returnData($json);		
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
}

function returnData($json){
	
	$json1 = json_encode($json);

	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Update Successfully',	
	'data' => $json);

	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}

 
?>