<?php
require_once('config.php');

$error_message;
$valid = true;

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$rowid = $data['rowid'];
$jni_mst_reference_no = $data['jni_mst_reference_no'];
$jni_mst_status = $data['jni_mst_status'];
$jni_mst_sch_date = $data['jni_mst_sch_date'];
$jni_mst_ins_date = $data['jni_mst_ins_date'];
$jni_mst_ver_date = $data['jni_mst_ver_date'];
$jni_mst_ins_by_hosp = $data['jni_mst_ins_by_hosp'];
$jni_mst_ins_by_conc = $data['jni_mst_ins_by_conc'];
$jni_mst_ver_by = $data['jni_mst_ver_by'];
$jni_mst_varchar5 = $data['jni_mst_varchar5'];
$jni_mst_remark = $data['jni_mst_remark'];

$LOGINID = $data['audit_user'];

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}

$sql="UPDATE jni_mst SET							
			jni_mst_reference_no=?,		
			jni_mst_status=?,		
			jni_mst_sch_date=?,			
			jni_mst_ins_date=?,		
			jni_mst_ver_date=?,			
			jni_mst_ins_by_hosp=?,
			jni_mst_ins_by_conc=?,
			jni_mst_ver_by=?,
			jni_mst_varchar5=?,
			jni_mst_remark=?,
			audit_user=?,
			audit_date=getdate()
		WHERE site_cd=? 
		AND rowid=?";	
				
	//echo $sql;
	$params = array($jni_mst_reference_no,	$jni_mst_status,	$jni_mst_sch_date,	$jni_mst_ins_date,	$jni_mst_ver_date,	$jni_mst_ins_by_hosp, $jni_mst_ins_by_conc, $jni_mst_ver_by, $jni_mst_varchar5,$jni_mst_remark, 	$LOGINID, $site_cd, $rowid);					
						
	$stmt = sqlsrv_query( $conn, $sql,$params);

	if( !$stmt ) {
		$error_message = "Error UPDATE Table (jni_mst)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt) );
	sqlsrv_free_stmt( $stmt);	


if( $stmt) {
	 sqlsrv_commit( $conn );
	 sqlsrv_close( $conn);	
	 returnData($json);		
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
}

function returnData($json){
	
	$json1 = json_encode($json);

	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'UPDATE Successfully',	
	'data' => $json);

	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}

 
?>