<?php
require_once('config.php');

$error_message;
$valid = true;

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$rowid = $data['rowid'];
$dww_mst_cc_id = $data['dww_mst_cc_id'];
$dww_mst_cc_name = $data['dww_mst_cc_name'];
$dww_mst_cn_no = $data['dww_mst_cn_no'];
$LOGINID = $data['LOGINID'];

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}

$sql="UPDATE dww_mst SET					
			dww_mst_cc_id=?,			
			dww_mst_cc_name=?,
			dww_mst_cn_no=?,
			audit_user=?,
			audit_date=getdate()
		WHERE site_cd=? 
		AND rowid=?";	
				
	//echo $sql;
	$params = array($dww_mst_cc_id,	$dww_mst_cc_name, $dww_mst_cn_no, $LOGINID, $site_cd, $rowid);					
						
	$stmt = sqlsrv_query( $conn, $sql, $params);

	if( !$stmt ) {
		$error_message = "Error UPDATE Table (dww_mst)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt) );
	sqlsrv_free_stmt( $stmt);	


if( $stmt) {
	 sqlsrv_commit( $conn );
	 sqlsrv_close( $conn);	
	 returnData($json);		
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
}

function returnData($json){
	
	$json1 = json_encode($json);

	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'UPDATE Successfully');

	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}

 
?>