<?php
require_once('config.php');

$error_message;
$valid = true;

$json = file_get_contents('php://input');

// Converts it into a PHP object
$data = json_decode($json, true);

$site_cd = $data['site_cd'];
$rowid = $data['rowid'];
$clw_mst_clw_date = $data['clw_mst_clw_date'];
$clw_mst_status = $data['clw_mst_status'];
$clw_mst_shift = $data['clw_mst_shift'];
$clw_mst_ttl_weight = $data['clw_mst_ttl_weight'];
$clw_mst_check_by = $data['clw_mst_check_by'];
$clw_mst_note = $data['clw_mst_note'];

$LOGINID = $data['LOGINID'];

/* Begin the transaction. */
if ( sqlsrv_begin_transaction( $conn ) === false ) {
     die( print_r( sqlsrv_errors(), true ));
}

$sql="UPDATE clw_mst SET							
			clw_mst_clw_date=?,		
			clw_mst_status=?,		
			clw_mst_shift=?,			
			clw_mst_ttl_weight=?,		
			clw_mst_check_by=?,			
			clw_mst_note=?,
			audit_user=?,
			audit_date=getdate()
		WHERE site_cd=? 
		AND rowid=?";	
				
	//echo $sql;
	$params = array($clw_mst_clw_date,	$clw_mst_status,	$clw_mst_shift,	$clw_mst_ttl_weight,	$clw_mst_check_by,	$clw_mst_note, 	$LOGINID, $site_cd, $rowid);					
						
	$stmt = sqlsrv_query( $conn, $sql, $params);

	if( !$stmt ) {
		$error_message = "Error UPDATE Table (clw_mst)";
		returnError($error_message);
		die( print_r( sqlsrv_errors(), true));
	}

	$json= array();

	do {
		 while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {	
		 
			$json[] = $row;		
		
		 }
	} while ( sqlsrv_next_result($stmt) );
	sqlsrv_free_stmt( $stmt);	


if( $stmt) {
	 sqlsrv_commit( $conn );
	 sqlsrv_close( $conn);	
	 returnData($json);		
} else {
	 sqlsrv_rollback( $conn );
	 $error_message = "Transaction rolled back.<br />";
	 returnError($error_message);
}

function returnData($json){
	
	$json1 = json_encode($json);

	$returnData = array(
	'status' => 'SUCCESS',
	'message' => 'Successfully',	
	'data' => $json);

	echo json_encode($returnData);
}

function returnError($error_message){	
	
	$returnData = array(
	'status' => 'ERROR',
	'message' => $error_message);	
	echo json_encode($returnData);
	exit();
}

 
?>